{**
 * Mercadopago Payments Module for Prestashop
 *
 * @author    Rinku Kazeno <development@kazeno.co>
 *
 * @copyright Copyright (c) 2012-2015, Rinku Kazeno
 * @license   This module is licensed to the user, upon purchase
 *  from either Prestashop Addons or directly from the author,
 *  for use on a single commercial Prestashop install, plus an
 *  optional separate non-commercial install (for development/testing
 *  purposes only). This license is non-assignable and non-transferable.
 *  To use in additional Prestashop installations an additional
 *  license of the module must be purchased for each one.
 *
 *  The user may modify the source of this module to suit their
 *  own business needs, as long as no distribution of either the
 *  original module or the user-modified version is made.
 *
 *  @file-version 2.19
 *}

<fieldset class="panel" style="width: 400px; position: relative; left: 10px; margin-top: 26px;">
    <legend>
        <img src="../modules/{$moduleName|escape:'htmlall':'UTF-8'}/logo.gif" alt="logo"/> {$mpTitle|escape:'htmlall':'UTF-8'}
    </legend>
    {if $transactionError}
        {$transactionError|escape:'htmlall':'UTF-8'}
    {else}
        {$mpIdTitle|escape:'htmlall':'UTF-8'}: {$mpId|escape:'htmlall':'UTF-8'}<br/>
        {$mpTransactionTitle|escape:'htmlall':'UTF-8'}: {$transactionId|escape:'htmlall':'UTF-8'}<br/>
        {$mpStatusTitle|escape:'htmlall':'UTF-8'}: {$mpStatus|escape:'htmlall':'UTF-8'}<br/>
        {if $paidFee != 0}
            {$mpFeeTitle|escape:'htmlall':'UTF-8'}: {$currencySign|escape:'htmlall':'UTF-8'}{$paidFee|escape:'htmlall':'UTF-8'}
        {/if}<br/>
        {if $amountDiscrepancy}
            <div class="warn alert alert-danger">
                {$amountDiscrepancyWarning|escape:'htmlall':'UTF-8'} {$mpId|escape:'htmlall':'UTF-8'}<br/>
                {$totalPayedTitle|escape:'htmlall':'UTF-8'} {$currencySign|escape:'htmlall':'UTF-8'} {$collection['transaction_amount']|escape:'htmlall':'UTF-8'}
            </div><br/>
        {/if}
        {if $cartOrderDiscrepancy}
            <div class="warn alert alert-warning">
                {$cartOrderDiscrepancyWarning|escape:'htmlall':'UTF-8'}<br/>
                {$cartPayedTitle|escape:'htmlall':'UTF-8'}: {$currencySign|escape:'htmlall':'UTF-8'}{$cartTotal|escape:'htmlall':'UTF-8'}
            </div>
        {/if}
        {if $carrierDiscrepancy}
            <div class="warn alert alert-warning">
                {$carrierDiscrepancyWarning|escape:'htmlall':'UTF-8'}<br/>
                {$cartCarrierTitle|escape:'htmlall':'UTF-8'}: {$cartCarrier|escape:'htmlall':'UTF-8'}<br/>
                {$orderCarrierTitle|escape:'htmlall':'UTF-8'}: {$orderCarrier|escape:'htmlall':'UTF-8'}
            </div>
        {/if}
        {if $showCollection}
            <pre>{$collectionPrint|escape:'htmlall':'UTF-8'}</pre>
        {/if}
    {/if}
</fieldset>